<?php

namespace App\Models;

use CodeIgniter\Model;

class EstudianteModel extends Model
{
    protected $table = 'estudiantes';
    protected $primaryKey = 'id_estudiante';
    protected $allowedFields = [
        'codigo_estudiante', 'nombres', 'apellidos', 
        'email', 'telefono', 'direccion', 'estado'
    ];
    protected $useTimestamps = false;
    
    public function buscarEstudiantes($query)
    {
        return $this->like('nombres', $query)
                    ->orLike('apellidos', $query)
                    ->orLike('codigo_estudiante', $query)
                    ->where('estado', 'activo')
                    ->findAll();
    }
}
