<?php

namespace App\Models;

use CodeIgniter\Model;

class MateriaModel extends Model
{
    protected $table = 'materias';
    protected $primaryKey = 'id_materia';
    protected $allowedFields = [
        'nombre_materia',
        'descripcion',
        'grado',
        'seccion',
        'id_docente'
    ];
    protected $useTimestamps = true;
    protected $createdField = 'created_at';
    protected $updatedField = 'updated_at';
    
    /**
     * Obtener materias de un docente con cantidad de estudiantes
     */
    public function getMateriasConEstudiantes($idDocente)
    {
        return $this->select('materias.*, COUNT(materia_estudiante.id_estudiante) as total_estudiantes')
            ->join('materia_estudiante', 'materia_estudiante.id_materia = materias.id_materia', 'left')
            ->where('materias.id_docente', $idDocente)
            ->groupBy('materias.id_materia')
            ->findAll();
    }
    
    /**
     * Asignar estudiante a materia
     */
    public function asignarEstudiante($idMateria, $idEstudiante)
    {
        $db = \Config\Database::connect();
        
        // Verificar si ya está asignado
        $existe = $db->table('materia_estudiante')
            ->where('id_materia', $idMateria)
            ->where('id_estudiante', $idEstudiante)
            ->get()
            ->getRowArray();
        
        if ($existe) {
            return false; // Ya está asignado
        }
        
        return $db->table('materia_estudiante')->insert([
            'id_materia' => $idMateria,
            'id_estudiante' => $idEstudiante
        ]);
    }
    
    /**
     * Desasignar estudiante de materia
     */
    public function desasignarEstudiante($idMateria, $idEstudiante)
    {
        $db = \Config\Database::connect();
        
        return $db->table('materia_estudiante')
            ->where('id_materia', $idMateria)
            ->where('id_estudiante', $idEstudiante)
            ->delete();
    }
    
    /**
     * Obtener estudiantes de una materia
     */
    public function getEstudiantesDeMateria($idMateria)
    {
        $db = \Config\Database::connect();
        
        return $db->table('estudiantes')
            ->select('estudiantes.*')
            ->join('materia_estudiante', 'materia_estudiante.id_estudiante = estudiantes.id_estudiante')
            ->where('materia_estudiante.id_materia', $idMateria)
            ->get()
            ->getResultArray();
    }
    
    /**
     * Obtener materias de un estudiante
     */
    public function getMateriasDeEstudiante($idEstudiante)
    {
        $db = \Config\Database::connect();
        
        return $db->table('materias')
            ->select('materias.*')
            ->join('materia_estudiante', 'materia_estudiante.id_materia = materias.id_materia')
            ->where('materia_estudiante.id_estudiante', $idEstudiante)
            ->get()
            ->getResultArray();
    }
}
