<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

$routes->get('/', 'Home::index');

// Rutas de API
$routes->group('api', function($routes) {
    
    // ========== AUTH (Rutas públicas) ==========
    $routes->post('login', 'AuthController::login');
    $routes->post('register', 'AuthController::register');

    // ========== RUTAS PROTEGIDAS (requieren autenticación) ==========
    $routes->group('', ['filter' => 'auth'], function($routes) {

        // ========== PERFIL ==========
        $routes->get('perfil', 'AuthController::perfil');
        $routes->put('perfil', 'AuthController::actualizarPerfil');
        $routes->put('cambiar-password', 'AuthController::cambiarPassword');
        $routes->delete('cuenta', 'AuthController::eliminarCuenta');
        
        // ========== ESTUDIANTES ==========
        $routes->get('estudiantes', 'EstudiantesController::index');
        $routes->get('estudiantes/(:num)', 'EstudiantesController::show/$1');
        $routes->post('estudiantes', 'EstudiantesController::create');
        $routes->put('estudiantes/(:num)', 'EstudiantesController::update/$1');
        $routes->delete('estudiantes/(:num)', 'EstudiantesController::delete/$1');
        
        // ========== ASISTENCIAS ==========
        // ⚠️ RUTAS ESPECÍFICAS PRIMERO
        $routes->get('asistencias/estadisticas', 'AsistenciasController::estadisticas');
        $routes->get('asistencias/fecha/(:segment)', 'AsistenciasController::porFecha/$1');
        $routes->get('asistencias/historial/(:num)', 'AsistenciasController::historialEstudiante/$1');
        
        // Rutas CRUD genéricas
        $routes->get('asistencias', 'AsistenciasController::index');
        $routes->get('asistencias/(:num)', 'AsistenciasController::show/$1');
        $routes->post('asistencias', 'AsistenciasController::create');
        $routes->put('asistencias/(:num)', 'AsistenciasController::update/$1');
        $routes->delete('asistencias/(:num)', 'AsistenciasController::delete/$1');

        // ========== MATERIAS ==========
        // ⚠️ RUTAS CON /estudiantes PRIMERO
        $routes->get('materias/(:num)/estudiantes', 'MateriasController::getEstudiantes/$1');
        $routes->post('materias/(:num)/estudiantes', 'MateriasController::asignarEstudiante/$1');
        $routes->delete('materias/(:num)/estudiantes/(:num)', 'MateriasController::desasignarEstudiante/$1/$2');
        
        // Rutas CRUD de materias
        $routes->get('materias', 'MateriasController::index');
        $routes->get('materias/(:num)', 'MateriasController::show/$1');
        $routes->post('materias', 'MateriasController::create');
        $routes->put('materias/(:num)', 'MateriasController::update/$1');
        $routes->delete('materias/(:num)', 'MateriasController::delete/$1');
    });
});
